require ("scripts/style.lua");

TitleFont = {
	standardFont,
	32,
	Color(0,0,255,255)
};

HeaderFont = {
	standardFont,
	24,
	RedColor
};

CoopHeaderFont = {
	standardFont,
	24,
	Color(0,0,255,255)
}
;	
HeaderStyle = {
	parent = DefaultStyle,
	font = HeaderFont,
	w = kMax,
	h = 200,
	flags = kHAlignLeft + kVAlignTop,
};

DescripFont = {
	standardFont,
	18,
	BorderColor
};

MPDescripFont = {
	standardFont,
	22,
	BlackColor
};
	
DescripStyle = {
	parent = DefaultStyle,
	font = DescripFont,
	w = 170,
	h = 200,
	flags = kHAlignLeft + kVAlignTop,
};

MakeDialog
{
	Bitmap
	{
		name="backgroundimage",
		image="backgrounds/fullscreendialog",
		x=0, y=0, w=kMax, h=kMax,
		
		Text
		{
			font = TitleFont,
			x=0,y=30,w=kMax,h=80,
			flags = kHAlignCenter + kVAlignTop,
			label = "mp_howtoplay"
		};
		
		SetStyle(DefaultStyle);
		
		Text
		{
			font = MPDescripFont,
			x=50,y=100,w=kMax,h=25,
			flags = kHAlignLeft + kVAlignTop,
			label = "mp_help1_1"
		};
		Text
		{
			font = MPDescripFont,
			x=50,y=125,w=kMax,h=25,
			flags = kHAlignLeft + kVAlignTop,
			label = "mp_help1_2"
		};
		
		Text
		{
			font = MPDescripFont,
			x=50,y=165,w=kMax,h=25,
			flags = kHAlignLeft + kVAlignTop,
			label = "mp_help1_3"
		};
		
		Text
		{
			font = CoopHeaderFont,
			x=50,y=215,w=kMax,h=25,
			flags = kHAlignLeft + kVAlignTop,
			label = "mp_help1_4"
		};

		Text
		{
			font = DescripFont,
			x=50,y=245,w=400,h=95,
			flags = kHAlignLeft + kVAlignTop,
			label = "mp_help1_5"
		};
		
		Bitmap
		{
			x = 50,
			y = 310,
			image = "multi/help_cooperativeui"
		};
		
		Text
		{
			font = HeaderFont,
			x=250,y=380,w=kMax,h=25,
			flags = kHAlignLeft + kVAlignTop,
			label = "mp_help1_6"
		};

		Text
		{
			font = DescripFont,
			x=250,y=410,w=450,h=95,
			flags = kHAlignLeft + kVAlignTop,
			label = "mp_help1_7"
		};
		
		Bitmap
		{
			x = 250,
			y = 465,
			image = "multi/help_competitiveui"
		};

		SetStyle(SmallestButtonStyle);
		Button
		{
			x=kCenter,
			y=540,
			name="back",
			label="back",
			command=
				function()
					ActivateHelpClock(false);
					PopModal("scripts/multiplayer/help1.lua");
				end
		},
		SetStyle(HelpArrowStyle);
		
		
		Button
		{
			x=700,
			y=530,
			hflip = true,
			name="right",
			command=
				function()
					SwapToModalSetName("scripts/multiplayer/help2.lua");
				end
		},
	},
};

ActivateHelpClock(true);